* graph empl/unemp/gdp/hours
 label var year_q " "

twoway line empli_us empli_d empli_uk year_q if year>=2007,scheme(s1mono) saving(empl,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(98.5 201000 "United Kingdom",color(gs5)) text(101 201000 "Germany") text(93.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) title("C. Employment",position(11) size(medium)) lcolor(gs0 gs0 gs5) lpattern(l l -)

twoway line unemp_us unemp_d unemp_uk year_q if year>=2007 ,scheme(s1mono) saving(unemp,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(8.4 201025 "United Kingdom",color(gs5)) text(9.3 200850 "United States") text(7.5 200775 "Germany") ytitle("Percent") ylabel(4 5 6 7 8 9 10,angle(0)) title("B. Unemployment rate",position(11) size(medium)) lcolor(gs0 gs0 gs5) lpattern(l l -)

twoway line gdpi_us gdpi_d gdpi_uk year_q if year>=2007,scheme(s1mono) saving(gdp,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(98.5 201075 "United",color(gs5)) text(97.5 201065 "Kingdom",color(gs5))  text(95 200900 "Germany") text(102.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) title("A. GDP",position(11) size(medium)) lcolor(gs0 gs0 gs5) lpattern(l l -)

* use Hobijn total nonfarm estimates
twoway line hoursworki_usH hoursworki_d hoursworki_uk year_q if year>=2007,scheme(s1mono) saving(hourswork,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(96.5 201000 "United Kingdom",color(gs5)) text(102.5 201000 "Germany") text(91.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) title("D. Person hours",position(11) size(medium)) lcolor(gs0 gs0) lpattern(l l -)

twoway line lforcei_us lforcei_d year_q||if year>=2007,scheme(s1mono) saving(laborforce,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050,val angle(vertical)) text(99 201000 "Germany") text(102 200850 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) title("E. Labor force",position(11) size(medium))

graph combine gdp.gph unemp.gph empl.gph hourswork.gph,scheme(s1mono) imargin(tiny)
graph export figure1.eps,replace logo(off) mag(130)
/*

* do differently for talk
* GDP w/o uk
twoway line gdpi_us gdpi_d year_q if year>=2007,scheme(s1color) saving(gdpt,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical))   text(95 200900 "Germany") text(102.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) lpattern(l l) lcolor(green orange)
graph export tfigure1gdp.eps,replace logo(off) mag(130)

* GDP with uk
twoway line gdpi_us gdpi_d gdpi_uk year_q if year>=2007,scheme(s1color) saving(gdptb,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(98 201075 "United",color(gs6)) text(97.5 201065 "Kingdom",color(gs6))  text(95 200900 "Germany") text(102.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) lpattern(l l -) lcolor(green orange gs6)

graph export tfigure1gdpb.eps,replace logo(off) mag(130)

* unemployment
* no uk
twoway line unemp_us unemp_d year_q if year>=2007 ,scheme(s1color) saving(unempt,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(9.3 200875 "United States") text(7.5 200775 "Germany") ytitle("Percent") ylabel(4 5 6 7 8 9 10,angle(0)) lcolor(green orange)
graph export tfigure1unemp.eps,replace logo(off) mag(130)

* uk
twoway line unemp_us unemp_d unemp_uk year_q if year>=2007 ,scheme(s1color) saving(unempt,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(8.4 201025 "United Kingdom",color(gs6)) text(9.3 200875 "United States") text(7.5 200775 "Germany") ytitle("Percent") ylabel(4 5 6 7 8 9 10,angle(0)) lcolor(green orange gs6) lpattern(l l -)

graph export tfigure1unempb.eps,replace logo(off) mag(130)

* employment
* no uk
twoway line empli_us empli_d year_q if year>=2007,scheme(s1color) saving(emplt,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(101 201000 "Germany") text(93.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) lcolor(green orange gs5) 
graph export tfigure1empl.eps,replace logo(off) mag(130)

* uk
twoway line empli_us empli_d empli_uk year_q if year>=2007,scheme(s1color) saving(empltb,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(98.5 201000 "United Kingdom",color(gs5)) text(101 201000 "Germany") text(93.5 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) lcolor(green orange gs5) lpattern(l l -)

graph export tfigure1emplb.eps,replace logo(off) mag(130)

twoway line hoursworki_usH hoursworki_d year_q if year>=2007,scheme(s1color) saving(hourswork,replace) legend(off) xlabel(200700 200750 200800 200850 200900 200950 201000 201050 ,val angle(vertical)) text(102.5 201000 "Germany") text(95 201000 "United States") ytitle("Q1 2007=100") ylabel(91 93 95 97 99 101 103,angle(0)) lcolor(green orange)

graph export tfigure1hours.eps,replace logo(off) mag(130)


